
% Requires MATLAB R2014b or later, and the following Toolboxes:
% Signal Processing Toolbox
% Image Processing Toolbox
% Statistics and Machine Learning Toolbox
% Database Toolbox
% Model-Based Calibration Toolbox
% Bioinformatics Toolbox

clear all
% Specify the path for zaps.mat file
s = load('\\101.101.1.113\data\Ippei\Publication\Behaviors\zaps.mat');
fn = fieldnames(s);
ss = length(fn);
dv = 5;

for sz = 1:ss
    nm = fn(sz);
    cl = s.(fn{sz});
    wm = size(cl, 1);
    dr{sz, 1} = nm;
    for cc = 1:wm
        dr{sz, 2}(cc, 1) = cl{cc, 3} - cl{cc, 2};
    end
    dr{sz, 2}( isnan(dr{sz, 2}) ) = 0;
    dr{sz, 3} = mean(dr{sz, 2}) * 50 / 1000;
    dr{sz, 4} = std(dr{sz, 2}) * 50 / 1000;
    dr{sz, 5} = dr{sz, 4} ./ sqrt(wm); % SE
    dr{sz, 6} = dr{sz, 5} .* 1.386; % CI83
    dr{sz, 7} = wm;
end

cl = [0.8 0.5 0.5];
posF = [100 100 350 300];
figure('Position', posF);
hold on

for x = 1:dv
    terrorbar(x, [dr{x, 3}], [dr{x, 6}], [dr{x, 6}], 0.25, 'units');
    line(x, [dr{x, 3}], 'Marker', 'o', 'MarkerSize', 8, 'MarkerFaceColor', cl, 'MarkerEdgeColor', cl);
    line(x, [dr{x, 3}], 'Marker', 'o', 'MarkerSize', 2, 'MarkerFaceColor', 'k', 'MarkerEdgeColor', 'k');
end

st = {'N2 100mA', 'nsy-1 100mA', 'nsy-1 300mA', 'nsy-7 100mA'};
xlim([0.6, dv + 0.3]);
ylim([0 8]);
ylabels = linspace( 0, 8, 5);
set(gca, 'YTick',  ylabels);
hold off

figure('Position', posF);
hold on
for x = 6:ss
    terrorbar(x, [dr{x, 3}], [dr{x, 6}], [dr{x, 6}], 0.25, 'units');
    line(x, [dr{x, 3}], 'Marker', 'o', 'MarkerSize', 8, 'MarkerFaceColor', cl, 'MarkerEdgeColor', cl);
    line(x, [dr{x, 3}], 'Marker', 'o', 'MarkerSize', 2, 'MarkerFaceColor', 'k', 'MarkerEdgeColor', 'k');
end

st = {'-AWC^{ON} 100mA', '-AWC^{OFF} 100mA', '-AWC^{OFF} 300mA', '-AWC^{OFF} 500mA', '-AWC 100mA', '-AWC 300mA'};
xlim([dv + 1 - 0.3, ss + 0.3]);
ylim([0 10]);
ylabels = linspace( 0, 10, 6);
set(gca, 'YTick',  ylabels);
hold off

stats.dataPlot = cell2table(dr);
stats.dataPlot.Properties.VariableNames = {'Name', 'Data', 'Mean', 'SD', 'SE', 'CI83', 'NumWorms'};
s = ntests(dr(:,2));
stats.statsPlot = s;
save('stats.mat', 'stats');


